/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.configs;

import com.google.gson.JsonObject;
import java.util.Locale;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.configs.EarlyConfigs;
import net.mehvahdjukaar.selene.block_set.BlockSetManager;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.BlockTypeRegistry;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public record BlockTypeEnabledCondition(BlockType type) implements ICondition
{
    private static final String CONDITION_NAME = "class";
    private static final String TYPE_NAME = "id";
    public static final ResourceLocation ID = WoodGood.res("type_enabled");

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        return EarlyConfigs.isTypeEnabled(this.type);
    }

    public boolean test() {
        return EarlyConfigs.isTypeEnabled(this.type);
    }

    public static class Serializer
    implements IConditionSerializer<BlockTypeEnabledCondition> {
        public void write(JsonObject json, BlockTypeEnabledCondition value) {
            json.addProperty(BlockTypeEnabledCondition.CONDITION_NAME, value.type.getClass().getSimpleName().toLowerCase(Locale.ROOT));
            json.addProperty(BlockTypeEnabledCondition.TYPE_NAME, value.type.id.toString());
        }

        public BlockTypeEnabledCondition read(JsonObject json) {
            String type = json.getAsJsonPrimitive(BlockTypeEnabledCondition.CONDITION_NAME).getAsString();
            String name = json.getAsJsonPrimitive(BlockTypeEnabledCondition.TYPE_NAME).getAsString();
            for (BlockTypeRegistry r : BlockSetManager.getRegistries()) {
                if (!r.getType().getSimpleName().toLowerCase(Locale.ROOT).equals(type)) continue;
                return new BlockTypeEnabledCondition(r.get(new ResourceLocation(name)));
            }
            WoodGood.LOGGER.error((Object)new UnsupportedOperationException("Unrecognized block type " + type));
            return new BlockTypeEnabledCondition((BlockType)WoodType.OAK_WOOD_TYPE);
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

